<?php
// File: /public/transactions.php
require_once '../includes/db.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

requireLogin();
$user_id = $_SESSION['user_id'];

// Fetch all transactions
$stmt = $pdo->prepare("SELECT * FROM transactions WHERE user_id = ? ORDER BY created_at DESC");
$stmt->execute([$user_id]);
$transactions = $stmt->fetchAll();

$page_title = "Transaction History";
include '../includes/header.php';
?>

<div class="card">
    <h3 class="mb-4">All Transactions</h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Date</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Description</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($transactions) > 0): ?>
                    <?php foreach ($transactions as $tx): ?>
                        <tr>
                            <td>#<?php echo $tx['id']; ?></td>
                            <td><?php echo date('M d, Y H:i', strtotime($tx['created_at'])); ?></td>
                            <td>
                                <span class="badge badge-primary">
                                    <?php echo ucfirst($tx['type']); ?>
                                </span>
                            </td>
                            <td class="<?php echo $tx['type'] == 'deposit' || $tx['type'] == 'profit' ? 'text-success' : 'text-danger'; ?>">
                                <?php echo ($tx['type'] == 'deposit' || $tx['type'] == 'profit' ? '+' : '-') . formatMoney($tx['amount']); ?>
                            </td>
                            <td class="text-muted"><?php echo htmlspecialchars($tx['description']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" class="text-center text-muted">No transactions found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
